// [License]
// The Ariba-Underlay Copyright
//
// Copyright (c) 2008-2009, Institute of Telematics, Universität Karlsruhe (TH)
//
// Institute of Telematics
// Universität Karlsruhe (TH)
// Zirkel 2, 76128 Karlsruhe
// Germany
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE INSTITUTE OF TELEMATICS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE ARIBA PROJECT OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// The views and conclusions contained in the software and documentation
// are those of the authors and should not be interpreted as representing
// official policies, either expressed or implied, of the Institute of
// Telematics.
// [License]

#ifndef __TIMER_H
#define __TIMER_H

#include <stdint.h>
#include "ariba/utility/system/SystemEventListener.h"
#include "ariba/utility/system/SystemQueue.h"
#include "ariba/utility/system/SystemEvent.h"
#include "ariba/utility/system/SystemEventType.h"
#include "ariba/utility/logging/Logging.h"

#ifndef UNDERLAY_OMNET
  #include <boost/thread/mutex.hpp>
  #include <boost/thread/thread.hpp>
  #include <boost/thread/condition_variable.hpp>
#endif

using ariba::utility::SystemEventType;
using ariba::utility::SystemQueue;
using ariba::utility::SystemEventListener;

namespace ariba {
namespace utility {

class Timer : public SystemEventListener {
	use_logging_h(Timer);
public:
	Timer();
	virtual ~Timer();

	/**
	 * Set the interval for the timer
	 *
	 * @param millis Timer interval in milliseconds
	 * @param oneshot Is this a one-shot or periodic timer
	 */
	void setInterval(unsigned int millis, bool oneshot=false);

	/**
	 * Start the timer
	 */
	void start();

	/**
	 * Stop the timer
	 */
	void stop();

	/**
	 * Reset a running timer and ignore the remaining interval
	 * time. Does not fire the timer event and start the timer
	 * with a new interval.
	 */
	void reset();

	/**
	 * Is the timer already running?
	 */
	bool isRunning();

protected:
	virtual void eventFunction();

protected:
	virtual void handleSystemEvent( const SystemEvent& event );

private:
#ifndef UNDERLAY_OMNET
	static void threadFunc( Timer* obj );
	boost::thread* timerThread;
#endif // UNDERLAY_OMNET

	volatile unsigned int millis;
	volatile bool running;
	volatile bool oneshot;
};

}} // namespace ariba, common

#endif // __TIMER_H
