#ifndef TRANSPORT_PEER_HPP_
#define TRANSPORT_PEER_HPP_

#include "transport_protocol.hpp"
#include "../addressing/endpoint_set.hpp"

// namespace ariba::transport
namespace ariba {
namespace transport {

using namespace ariba::addressing;

class tcpip;
class rfcomm;

/**
 * TODO: Doc
 *
 * @author Sebastian Mies <mies@tm.uka.de>
 */
/// this transport peer allocates implemenations of various transport
/// protocols and can sent message to an entire set of endpoints
class transport_peer : public transport_protocol {
public:
	transport_peer( endpoint_set& local_set );
	virtual ~transport_peer();
	virtual void start();
	virtual void stop();
	virtual void send( const address_v* remote, const uint8_t* data, size_t size );
	virtual void send( const endpoint_set& endpoints, const uint8_t* data, size_t size );
	virtual void terminate( const address_v* local, const address_v* remote );
	virtual void register_listener( transport_listener* listener );

private:
	endpoint_set&  local;
	tcpip* tcp;
	rfcomm* rfc;
};

}} // namespace ariba::transport

#endif /* TRANSPORT_PEER_HPP_ */
