#include <string>
#include "ariba/utility/system/StartupWrapper.h"
#include "PingPong.h"

using std::string;
using ariba::utility::StartupWrapper;
using ariba::application::pingpong::PingPong;

//*************************************************
/*
#include "ariba/utility/bootstrap/BootstrapManager.h"
using ariba::utility::BootstrapManager;

void debug(){
	StartupWrapper::startSystem();

	BootstrapManager& manager = BootstrapManager::instance();
	manager.registerModule( BootstrapManager::BootstrapTypePeriodicBroadcast );

	manager.publish("testname", "testinfo1", "testinfo2", "testinfo3");
	getchar();
	manager.revoke("testname");

	manager.unregisterModule( BootstrapManager::BootstrapTypePeriodicBroadcast );
	StartupWrapper::stopSystem();
}
*/
//*************************************************

int main( int argc, char** argv ) {

	//debug();
	//return 0;

	// get config file
	string config = "../etc/settings.cnf";
	if (argc >= 2) config = argv[1];

	StartupWrapper::initConfig( config );
	StartupWrapper::startSystem();

	// this will do the main functionality and block
	PingPong ping;
	StartupWrapper::startup(&ping);

	// --> we will run blocking until <enter> is hit

	StartupWrapper::shutdown(&ping);
	StartupWrapper::stopSystem();

	return 0;
}
