#ifndef ARIBA_OVERLAY_LINKREQUEST_H_
#define ARIBA_OVERLAY_LINKREQUEST_H_

#include "ariba/utility/messages.h"
#include "ariba/utility/serialization.h"
#include "ariba/communication/EndpointDescriptor.h"

using ariba::communication::EndpointDescriptor;

namespace ariba {
namespace overlay {

using_serialization;

using ariba::utility::Message;

/**
 * This message is sent to another overlay node to request a new link.
 *
 * @author Sebastian Mies <mies@tm.uka.de>
 */
class LinkRequest : public Message {
	VSERIALIZEABLE;
private:
	bool free_endpoint_;
	uint16_t flags; //TODO: was uint8_t
	uint32_t nonce;
	const EndpointDescriptor* endpoint;

public:
	LinkRequest();

	LinkRequest( uint32_t nonce, const EndpointDescriptor* endpoint,
			bool reply = false );

	virtual ~LinkRequest();

	const EndpointDescriptor* getEndpoint() const {
		return endpoint;
	}

	bool isReply() const {
		return flags & 1;
	}

	uint32_t getNonce() const {
		return nonce;
	}
};

}} // ariba::overlay

sznBeginDefault( ariba::overlay::LinkRequest, X ) {
	if (X.isDeserializer()) endpoint = new EndpointDescriptor();
	X && flags && nonce && reinterpret_cast<VSerializeable*>(const_cast<EndpointDescriptor*>(endpoint));
} sznEnd();

#endif /* ARIBA_OVERLAY_LINKREQUEST_H_ */
