// [License]
// The Ariba-Underlay Copyright
//
// Copyright (c) 2008-2009, Institute of Telematics, Universität Karlsruhe (TH)
//
// Institute of Telematics
// Universität Karlsruhe (TH)
// Zirkel 2, 76128 Karlsruhe
// Germany
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE INSTITUTE OF TELEMATICS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE ARIBA PROJECT OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// The views and conclusions contained in the software and documentation
// are those of the authors and should not be interpreted as representing
// official policies, either expressed or implied, of the Institute of
// Telematics.
// [License]

#ifndef DISCOVERY_H__
#define DISCOVERY_H__

#include <vector>
#include "ariba/utility/messages.h"
#include "ariba/utility/serialization.h"
#include "ariba/utility/types/NodeID.h"
#include "ariba/communication/EndpointDescriptor.h"

using std::pair;
using std::make_pair;
using std::vector;
using ariba::utility::Message;
using ariba::utility::NodeID;
using ariba::communication::EndpointDescriptor;

namespace ariba {
namespace overlay {

using_serialization;

class Discovery : public Message {
	VSERIALIZEABLE;
public:
	enum follow_type_ {
		normal = 0,
		successor = 1,
		predecessor = 2
	};

	Discovery( const Discovery& msg ) {
		this->follow_type = msg.follow_type;
		this->ttl = msg.ttl;
		this->source_endpoint = new EndpointDescriptor( *msg.source_endpoint );
	}
	explicit Discovery();
	virtual ~Discovery();
/*
	typedef pair<NodeID,EndpointDescriptor*> NodeEndpoint;
	typedef vector<NodeEndpoint> NodeEndpointList;

	void add(const NodeID& node, EndpointDescriptor* endp);

	const NodeEndpointList& getList();
*/

	EndpointDescriptor* getSourceEndpoint() const {
		return source_endpoint;
	}

	void setSourceEndpoint( const EndpointDescriptor* endpoint ) {
		source_endpoint = const_cast<EndpointDescriptor*>(endpoint);
	}

	inline uint8_t getTTL() const {
		return ttl;
	}

	inline void setTTL( uint8_t ttl ) {
		this->ttl = ttl;
	}

	inline follow_type_ getFollowType() const {
		return (follow_type_)follow_type;
	}

	inline void setFollowType( follow_type_ type ) {
		follow_type = (uint8_t)type;
	}

private:
	uint16_t follow_type; //TODO: was uint8_t
	uint16_t ttl; //TODO: was uint8_t
	EndpointDescriptor* source_endpoint;
//	NodeEndpointList descriptors;
};

}} // ariba::overlay

sznBeginDefault( ariba::overlay::Discovery, X ) {

	/// serialize follow-type and time-to-live
	X && follow_type && ttl;

	// serialize end-point
	X && VO(source_endpoint);
/*
	// serialize length of descriptor list
	uint16_t len = descriptors.size();
	X && len;
	if (X.isDeserializer()) descriptors.resize(len);

	// serialize descriptors
	for (int i=0; i<len; i++)
		X && &descriptors[i].first && VO(descriptors[i].second);

	// serialize payload
	X && Payload();
*/
} sznEnd();

#endif // DISCOVERY_H__
