// [License]
// The Ariba-Underlay Copyright
//
// Copyright (c) 2008-2009, Institute of Telematics, Universität Karlsruhe (TH)
//
// Institute of Telematics
// Universität Karlsruhe (TH)
// Zirkel 2, 76128 Karlsruhe
// Germany
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE INSTITUTE OF TELEMATICS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE ARIBA PROJECT OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// The views and conclusions contained in the software and documentation
// are those of the authors and should not be interpreted as representing
// official policies, either expressed or implied, of the Institute of
// Telematics.
// [License]

#ifndef ARIBA_OMNET_MODULE_H__
#define ARIBA_OMNET_MODULE_H__

#include "ariba/utility/types.h"
#include "ariba/utility/messages.h"
#include "ariba/utility/types/Address.h"
#include "ariba/utility/misc/Helper.h"
#include "ariba/utility/logging/Logging.h"
#include "ariba/utility/serialization/DataStream.hpp"
#include "ariba/communication/modules/transport/TransportProtocol.h"
#include "ariba/communication/modules/transport/TransportLocator.h"
#include "ariba/communication/modules/network/ip/IPv4Locator.h"
#include "AribaOmnetMessage_m.h"
#include <omnetpp.h>
#include <INETDefs.h>
#include <TCPSocket.h>
#include <map>
#include <iostream>
#include <sstream>
#include <vector>

using std::vector;
using std::ostringstream;
using std::cout;
using std::pair;
using std::make_pair;
using std::map;
using std::multimap;
using ariba::utility::seqnum_t;
using ariba::utility::Message;
using ariba::utility::Address;
using ariba::utility::serialization::data_serialize;
using ariba::communication::IPv4Locator;

namespace ariba {
namespace communication {

class INET_API AribaOmnetModule : public cSimpleModule, public TransportProtocol, TCPSocket::CallbackInterface {

	use_logging_h( AribaOmnetModule );

public:
	AribaOmnetModule();
	virtual ~AribaOmnetModule();

	void setServerPort(uint16_t _port);

	/**
	 * see TransportProtocol
	 */
	virtual void start();
	virtual void stop();
	virtual TransportLocator::prot_t getId();
	virtual const vector<TransportLocator*> getLocators();
	virtual seqnum_t sendMessage( const Message* message );

	/**
	 * see TCPSocket::CallbackInterface
	 */
	virtual void socketDataArrived( int connId, void* socket, cMessage* msg, bool urgent );
	virtual void socketFailure( int connId, void* socket, int code );
	virtual void socketClosed( int connId, void* socket );
	virtual void socketPeerClosed( int connId, void* socket );
	virtual void socketEstablished( int connId, void* socket );
	virtual void socketStatusArrived( int connId, void* socket, TCPStatusInfo *status);

protected:
	/**
	 * Called from Omnet++ on initialization of the simulation
	 */
	virtual void initialize(int stage);
 	virtual int numInitStages () const ;

	/**
	 * Called from Omnet++ during simulation:
	 * called when the module receives a message
	 */
	virtual void handleMessage( cMessage* msg );

	/** Called from Omnet++ during simulation:
	 * called when the simulation terminates.
	 * Can be used for writing statistics and the likes.
	 */
	virtual void finish();

private:
	/**
	 * All our sockets to other nodes and the server socket
	 */
	TCPSocket serverSocket;
	typedef multimap<string, TCPSocket*> SocketMap;
	SocketMap sockets;
	uint16_t serverPort;

	/**
	 * Pending data that we have to send when the socket
	 * has been opened asynchronously
	 */
	typedef map<TCPSocket*, AribaOmnetMessage*> PendingSendQueue;
	PendingSendQueue pendingSends;

};

//
// The module class needs to be registered with OMNeT++
//

Define_Module( AribaOmnetModule );

}} // namespace ariba, communication

#endif // ARIBA_OMNET_MODULE_H__
