// [Licence]
// The Ariba-Underlay Copyright
//
// Copyright (c) 2008-2009, Institute of Telematics, Universität Karlsruhe (TH)
//
// Institute of Telematics
// Universität Karlsruhe (TH)
// Zirkel 2, 76128 Karlsruhe
// Germany
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE INSTITUTE OF TELEMATICS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE ARIBA PROJECT OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// The views and conclusions contained in the software and documentation
// are those of the authors and should not be interpreted as representing
// official policies, either expressed or implied, of the Institute of
// Telematics.
// [Licence]

#ifndef __SERVICE_INTERFACE_H
#define __SERVICE_INTERFACE_H

#include "ariba/overlay/OverlayEvents.h"
#include "ariba/utility/messages/MessageReceiver.h"
#include "ariba/utility/messages/Message.h"
#include "ariba/utility/types/LinkID.h"
#include "ariba/utility/types/SpoVNetID.h"
#include "ariba/utility/types/ServiceID.h"
#include "ariba/utility/types/NodeID.h"
#include "ariba/utility/types/QoSParameterSet.h"

namespace ariba {
namespace overlay {
	class BaseOverlay;
}}

using ariba::overlay::OverlayEvents;
using ariba::overlay::BaseOverlay;
using ariba::utility::MessageReceiver;
using ariba::utility::Message;
using ariba::utility::LinkID;
using ariba::utility::SpoVNetID;
using ariba::utility::ServiceID;
using ariba::utility::NodeID;
using ariba::utility::QoSParameterSet;

namespace ariba {
namespace interface {

class ServiceInterface : public OverlayEvents, MessageReceiver {
	friend class ariba::overlay::BaseOverlay;
public:
	ServiceInterface();
	virtual ~ServiceInterface();

protected:
	virtual bool isJoinAllowed( const NodeID& nodeid, const SpoVNetID& spovnetid );
	virtual void onNodeJoin( const NodeID& nodeid, const SpoVNetID& spovnetid );
	virtual void onNodeLeave( const NodeID& id, const SpoVNetID& spovnetid );

	virtual void onJoinSuccess( const SpoVNetID& spovnetid );
	virtual void onJoinFail( const SpoVNetID& spovnetid );
	virtual void onLeaveSuccess( const SpoVNetID& spovnetid );
	virtual void onLeaveFail( const SpoVNetID& spovnetid );

	virtual void onLinkUp( const LinkID& link, const NodeID& local, const NodeID& remote );
	virtual void onLinkDown( const LinkID& link, const NodeID& local, const NodeID& remote );
	virtual void onLinkChanged( const LinkID& link, const NodeID& local, const NodeID& remote );
	virtual void onLinkFail(const LinkID& id, const NodeID& local, const NodeID& remote );
	virtual void onLinkQoSChanged(const LinkID& id, const NodeID& local, const NodeID& remote , const QoSParameterSet& qos);

	virtual bool receiveMessage( const Message* message, const LinkID& link, const NodeID& node );
};

}} // namespace ariba, interface

#endif // __SERVICE_INTERFACE_H
