// [Licence]
// The Ariba-Underlay Copyright
//
// Copyright (c) 2008-2009, Institute of Telematics, Universität Karlsruhe (TH)
//
// Institute of Telematics
// Universität Karlsruhe (TH)
// Zirkel 2, 76128 Karlsruhe
// Germany
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE INSTITUTE OF TELEMATICS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE ARIBA PROJECT OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// The views and conclusions contained in the software and documentation
// are those of the authors and should not be interpreted as representing
// official policies, either expressed or implied, of the Institute of
// Telematics.
// [Licence]

#include "UnderlayAbstraction.h"

namespace ariba {
namespace interface {

use_logging_cpp(UnderlayAbstraction);

UnderlayAbstraction::UnderlayAbstraction() : basecomm( NULL ) {
}

UnderlayAbstraction::~UnderlayAbstraction() {
}

AribaContext* UnderlayAbstraction::createNode(const SpoVNetID& spovnetid, const NodeID& nodeid, const NetworkLocator* locallocator, const uint16_t localport) {

	logging_info( "creating node ...");

	NodeID newid = nodeid;

	if( nodeid == NodeID::UNSPECIFIED ){
		logging_debug( "nodeid is unspecified, creating random ..." );
		newid = NodeID( Identifier::random() );
		logging_info( "local nodeid is " << newid.toString() );
	}

	basecomm = new BaseCommunication( locallocator, localport );

	BaseOverlay* baseoverlay = new BaseOverlay( *basecomm, newid );
	AribaContext* ctx = new AribaContext( *basecomm, *baseoverlay, spovnetid, newid );

	logging_info( "spovnetid = " << ctx->getSpoVNetID().toString() <<
			", nodeid = " << ctx->getNodeID().toString() );

	return ctx;
}

AribaContext* UnderlayAbstraction::createSpoVNet(const SpoVNetID& spovnetid, const NodeID& nodeid, const NetworkLocator* locallocator, const uint16_t localport, const OverlayParameterSet& param, const SecurityParameterSet& sec, const QoSParameterSet& qos) {

	// create new node
	AribaContext* ctx = createNode( spovnetid, nodeid, locallocator, localport );

	// create new base overlay (initiator)
	logging_info("creating new spovnet...");
	ctx->getOverlay().createSpoVNet( spovnetid, param, sec, qos );
	logging_info("node created");

	return ctx;
}

AribaContext* UnderlayAbstraction::joinSpoVNet(const SpoVNetID& spovnetid, const EndpointDescriptor& bootstrapnode, const NodeID& nodeid, const NetworkLocator* locallocator, const uint16_t localport) {

	// create new node
	AribaContext* ctx = createNode( spovnetid, nodeid, locallocator, localport );

	// join spovnet
	logging_info("joining existing spovnet...");
	ctx->getOverlay().joinSpoVNet( spovnetid, bootstrapnode );
	logging_info("node created");

	return ctx;
}

void UnderlayAbstraction::leaveSpoVNet(AribaContext* ctx) {
	ctx->getOverlay().leaveSpoVNet();
	delete &ctx->getOverlay();
	delete &ctx->getBaseCommunication();
	delete ctx;
}

}} // namespace ariba, interface
