// [License]
// The Ariba-Underlay Copyright
//
// Copyright (c) 2008-2009, Institute of Telematics, Universität Karlsruhe (TH)
//
// Institute of Telematics
// Universität Karlsruhe (TH)
// Zirkel 2, 76128 Karlsruhe
// Germany
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE INSTITUTE OF TELEMATICS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE INSTITUTE OF TELEMATICS OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// The views and conclusions contained in the software and documentation
// are those of the authors and should not be interpreted as representing
// official policies, either expressed or implied, of the Institute of
// Telematics.
// [License]

#include "SpoVNetProperties.h"

namespace ariba {

const SpoVNetProperties SpoVNetProperties::DEFAULT;

SpoVNetProperties::SpoVNetProperties() :
		name( Name::random() ), type( ONE_HOP_OVERLAY ), idLength( 192 ),
		initiator( NodeID::UNSPECIFIED ), hidden( false ) {

	id = name.toSpoVNetId();
}

SpoVNetProperties::SpoVNetProperties(const SpoVNetProperties& copy) :
		name( copy.name ), id( copy.id ), 
		type( copy.type ), idLength( copy.idLength ),
		initiator( copy.initiator ), hidden( copy.hidden ) {
}

SpoVNetProperties::~SpoVNetProperties() {
}

const Name& SpoVNetProperties::getName() const {
	return name;
}

const SpoVNetID& SpoVNetProperties::getId() const {
	return id;
}

const NodeID& SpoVNetProperties::getInitiator() const {
	return initiator;
}

uint16_t SpoVNetProperties::getIdentifierLength() const {
	return idLength;
}

const SpoVNetProperties::OverlayType SpoVNetProperties::getBaseOverlayType() const {
	return (OverlayType)type;
}

bool SpoVNetProperties::isHidden() const {
	return hidden;
}

std::string SpoVNetProperties::toString() const {
	std::ostringstream buf;
	buf << "spovnet"
		<< " name=" << name.toString()
		<< " id=" << id.toString()
		<< " overlay_type=" << type 
		<< " id_length=" << idLength 
		<< " initiator=" << initiator
		<< " hidden=" << hidden;
	return buf.str();
}

} // namespace ariba
