#ifndef __PINGPONG_H_
#define __PINGPONG_H_

#include "ariba/ariba.h"
#include "PingPongMessage.h"

using namespace ariba;

#include "ariba/utility/system/StartupInterface.h"
#include "ariba/utility/system/Timer.h"
using ariba::utility::StartupInterface;
using ariba::utility::Timer;

namespace ariba {
namespace application {
namespace pingpong {

/**
/* The PingPong main class
/* This class implements an example service for demonstration purposes
/* The pingpong class sends and receives messages between two SpoVNet
/* instances
**/
class PingPong :
	public NodeListener,
	public CommunicationListener,
	public StartupInterface,
	public Timer {

	use_logging_h(PingPong);

public:
	PingPong();
	virtual ~PingPong();

protected:
	// communication listener interface
	virtual bool onLinkRequest(const NodeID& remote, Message* msg);
	virtual void onMessage(Message* msg, const NodeID& remote, const LinkID& lnk);

	// node listener interface
	virtual void onJoinCompleted( const SpoVNetID& vid );
	virtual void onJoinFailed( const SpoVNetID& vid );

	// startup wrapper interface
	virtual void startup();
	virtual void shutdown();

	// timer events
 	virtual void eventFunction();

private:
	// the ariba module and a node
	AribaModule* ariba;
	Node* node;

	// flag, wheter this node is the initiator of this spovnet
	bool isInitiator;

 	// the ping pong service id
 	static ServiceID PINGPONG_ID;

 	// the current ping id
 	unsigned long pingId;
};

//ARIBA_SIMULATION_SERVICE(PingPong);

}}} // namespace ariba, application, pingpong

#endif // __PINGPONG_H_
