#ifndef PINGPONGMESSAGES_H_
#define PINGPONGMESSAGES_H_

#include <string>
#include "ariba/utility/messages.h"
#include "ariba/utility/serialization.h"
#include "ariba/utility/misc/Helper.h"

using std::string;
using ariba::utility::Message;

namespace ariba {
namespace application {
namespace pingpong {

using_serialization;

class PingPongMessage : public Message {
	VSERIALIZEABLE;
public:
	PingPongMessage();
	PingPongMessage(uint8_t _id);
	virtual ~PingPongMessage();
	
	string info();
	uint8_t getid();

private:
	uint8_t id;
};

}}} // namespace ariba, appplication , pingpong

sznBeginDefault( ariba::application ::pingpong::PingPongMessage, X ) {
	X && id;
} sznEnd();

#endif /* PINGPONGMESSAGES_H_ */
