/*
 * The MIT License (MIT)
 * 
 * Copyright (c) 2013 Mario Hock mails2013@omnifile.org
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#ifndef UDP_H
#define UDP_H

#include "MessageSenderInterface.h"

#include <ctime>
#include <iostream>
#include <string>
#include <boost/array.hpp>
#include <boost/bind.hpp>
#include <boost/shared_ptr.hpp>
#include <boost/asio.hpp>

using boost::asio::ip::udp;

class udp_server  :
    public MessageSenderInterface
{
public:
    /// constructor
    udp_server(boost::asio::io_service& io_service,
             MessageSenderInterface& tunnel) :
        socket_(io_service),
        tunnel(tunnel)
    {
    }
    
    virtual ~udp_server();
    
    /// opens an udp "server-socket" on the given port
    void listen_on(uint16_t port);
    
    /// connects an udp "client-socket" to the given port (on localhost)
    void connect_to(uint16_t port);
    
    
    /// MessageSenderInterface
    virtual void SendMessage(reboost::message_t msg);
    virtual void SendMessage(reboost::shared_buffer_t msg);

private:
    void start_receive();

    void handle_receive(const boost::system::error_code& error,
            std::size_t bytes_transferred);
    
    void handle_send(reboost::shared_buffer_t msg,
        const boost::system::error_code& /*error*/,
        std::size_t /*bytes_transferred*/);
    
    /// forward data over ariba
    void send_via_ariba(reboost::shared_buffer_t buffer);

private:
    udp::socket socket_;
    MessageSenderInterface& tunnel;
    udp::endpoint remote_endpoint_;
    reboost::shared_buffer_t recv_buffer_;
};

#endif // UDP_H
