/*
 * endpoint_set.hpp
 *
 *  Created on: 27.03.2013
 *      Author: mario
 */

#ifndef ENDPOINT_SET_HPP_
#define ENDPOINT_SET_HPP_

// ariba
#include "endpoint.hpp"
#include "ariba/utility/transport/messages/shared_buffer.hpp"

// boost
#include <boost/shared_ptr.hpp>
#include <boost/property_tree/ptree.hpp>

// system
#include <vector>
#include <stdexcept>

namespace ariba {

using boost::property_tree::ptree;
using boost::shared_ptr;

namespace addressing2 {

/// forward declarations
class tcpip_endpoint;

/**
 * Holds a number of endpoints. (Usually of one particular node.)
 */
class endpoint_set
{
public:
    
    // factories
    static shared_ptr<endpoint_set> create_EndpointSet(const boost::property_tree::ptree& pt);
//    static shared_ptr<endpoint_set> create_EndpointSet(const std::string& str);
    static shared_ptr<endpoint_set> create_EndpointSet();
    
    endpoint_set();
    
//    endpoint_set(const std::string& str);
    endpoint_set(const boost::property_tree::ptree& pt);
    virtual ~endpoint_set();
    
    
    /**
     * Adds an endpoint to this set.
     * 
     * (Ignores duplicates)
     */
    void add_endpoint(EndpointPtr endpoint);
    
    /**
     * Adds all endpoints from the given set to this set.
     * 
     * (Ignores duplicates)
     */
    void add_endpoints(const boost::shared_ptr<endpoint_set> endpoints);
    
    /**
     * @return Human readable string representation of this endpoint-set.
     */
    std::string to_string() const;
    
    /**
     * @return a vector of all tcpip_endpoints in this set
     */
    const std::vector<shared_ptr<tcpip_endpoint> >& get_tcpip_endpoints() const;
    
    /**
     * This function serializes this endpoint_set with all its endpoints
     * into a shared buffer, which then can be sent to another node.
     * 
     * @return A byte-representation of this set saved into a shared_buffer.
     */
    reboost::shared_buffer_t serialize() const;
    
    /**
     * Recreates an endpoint_set from a shared buffer.
     * 
     * ---> Complementary to »endpoint_set::serialize_into_shared_buffer()«
     * 
     * @return remaining sub-buffer
     */
    reboost::shared_buffer_t deserialize(reboost::shared_buffer_t buff);

    
    /**
     * @return total number of endpoints in this set
     */
    int count() const
    {
        return tcpip_endpoints.size();
    }
    
private:
    std::vector<shared_ptr<tcpip_endpoint> > tcpip_endpoints;
};

typedef boost::shared_ptr<endpoint_set> EndpointSetPtr;
typedef boost::shared_ptr<const endpoint_set> const_EndpointSetPtr;

}} /* namespace addressing2::ariba */
#endif /* ENDPOINT_SET_HPP_ */
