#include "DhtMessage.h"

#include<boost/foreach.hpp>

namespace ariba_service {
namespace dht {

vsznDefault(DhtMessage);

DhtMessage::DhtMessage() :
	ttl( 0 ),
	replace( false ),
	sourceNode(NodeID::UNSPECIFIED)
{}

DhtMessage::DhtMessage( DhtMessageType type, const std::string& key, const NodeID& sourceNodeID ) :
	type( static_cast<uint8_t>(type) ),
	ttl( 0 ),
	replace( false ),
	key( key ),
	sourceNode(sourceNodeID)

{}

DhtMessage::DhtMessage( DhtMessageType type, const std::string& key,
		const std::string& value, uint16_t ttl, const NodeID& sourceNodeID ) :
	type( static_cast<uint8_t>(type) ),
	ttl( ttl ),
	replace( false ),
	key( key ),
	values(1, value),
	sourceNode(sourceNodeID)
{}

DhtMessage::DhtMessage( DhtMessageType type, const std::string& key,
		const vector<string>& values, uint16_t ttl, const NodeID& sourceNodeID ) :
	type( static_cast<uint8_t>(type) ),
	ttl( ttl ),
	replace( false ),
	key( key ),
	sourceNode(sourceNodeID)
{
	// preallocate enough room so we don't need to copy a lot
	this->values.reserve(values.size());
	BOOST_FOREACH(const std::string value, values )
		this->values.push_back( value );
}

DhtMessage::~DhtMessage() {
	// empty
}

string DhtMessage::DhtMessageTypeToString(DhtMessageType type) {
	string temp;
	switch (type)
	{
		case DhtMessage::DhtInvalid:
		{
			temp = "DhtInvalid";
			break;
		}

		case DhtMessage::DhtGet:
		{
			temp = "DhtGet";
			break;
		}

		case DhtMessage::DhtPut:
		{
			temp = "DhtPut";
			break;
		}

		case DhtMessage::DhtPutAndGet:
		{
			temp = "DhtPutAndGet";
			break;
		}

		case DhtMessage::DhtRemove:
		{
			temp = "DhtRemove";
			break;
		}

		case DhtMessage::DhtRepublish:
		{
			temp = "DhtRepublish";
			break;
		}

		case DhtMessage::DhtAnswer:
		{
			temp =  "DhtAnswer";
			break;
		}

		case DhtMessage::DhtReplica:
		{
			temp = "DhtReplica";
			break;
		}
	}

	return temp;
}

}}
