/*
 * tcpip_endpoint.h
 *
 *  Created on: 26.03.2013
 *      Author: mario
 */

#ifndef TCPIP_ENDPOINT_HPP_
#define TCPIP_ENDPOINT_HPP_

// TODO: maybe move this class ariba/utility/transport.. ?

#include "endpoint.hpp"

// boost
#include <boost/asio/ip/tcp.hpp>
#include <boost/shared_ptr.hpp>

using boost::shared_ptr;

namespace ariba {
namespace addressing2 {

class tcpip_endpoint: public endpoint
{
public:
    /**
     * Implements »endpoint«
     * @see endpoint.h
     * 
     * NOTE: An endpoint is designed as an unmutable object!
     */

    /// factories
    static boost::shared_ptr<tcpip_endpoint> create_TcpIP_Endpoint(
            const boost::asio::ip::tcp::endpoint& asio_endpoint);
    
    
    /// constructors
    
    /**
     * Creates a new »tcpip_endpoint« from a string representation.
     * ---> NOT complementary to »to_string()«
     */
    tcpip_endpoint(const std::string& ip_addr, const int port);
    
    /**
     * Creates a new »tcpip_endpoint« from a byte array.
     * ---> Complementary to »to_byte_array()«
     * 
     * May throw »invalid_argument« exception.
     */
    tcpip_endpoint(const ENDPOINT_TYPE type, const uint8_t* const byte_array, const int read_max);
    
    /**
     * Creates a new »tcpip_endpoint« from an ASIO tcp::endpoint.
     * ---> Complementary to »tcpip_endpoint::to_asio()«
     */
    tcpip_endpoint(const boost::asio::ip::tcp::endpoint& asio_endpoint);
    
    virtual ~tcpip_endpoint();
    
    
    /// from superclass
    virtual ENDPOINT_CATEGORY get_category() const;
    virtual ENDPOINT_TYPE get_type() const;
    virtual std::string to_string() const;
    virtual size_t to_byte_array(uint8_t* buffer) const;
    virtual int size() const;
    
    
    /**
     * @return An equivalent ASIO tcp::endpoint
     */
    const boost::asio::ip::tcp::endpoint& to_asio() const;
    
    /**
     * @return »true« if rhs points to the same Address:Port pair,
     * otherwise returns »false«.  
     */
    bool equals(const shared_ptr<tcpip_endpoint>& rhs) const;
    
    
private:
    boost::asio::ip::tcp::endpoint asio_endpoint;
};

typedef boost::shared_ptr<tcpip_endpoint> TcpIP_EndpointPtr;
//typedef boost::shared_ptr<const tcpip_endpoint> const_TcpIP_EndpointPtr;

}} /* namespace ariba::addressing2 */
#endif /* TCPIP_ENDPOINT_HPP_ */
