// transport_listener.hpp, created on 01.07.2009 by Sebastian Mies

#ifndef TRANSPORT_LISTENER_HPP
#define TRANSPORT_LISTENER_HPP

// ariba
#include "ariba/utility/transport/messages/buffers.hpp"

// ariba interfaces
#include "transport_connection.hpp"

// namespace ariba::transport
namespace ariba {
namespace transport {

/**
 * TODO: Doc
 *
 * @author Sebastian Mies <mies@tm.uka.de>
 */
class transport_listener {
public:
    /// Allow deleting implementing classes by pointer
    virtual ~transport_listener() {}
    
	/// called when a message is received
	virtual void receive_message(
        transport_connection::sptr connection,
		reboost::shared_buffer_t msg
	) = 0;
	
	/// called when a connection is terminated (e.g. TCP close)
	virtual void connection_terminated(transport_connection::sptr connection) = 0;
};

}} // namespace ariba::transport


#endif /* TRANSPORT_LISTENER_HPP */
