// [License]
// The Ariba-Underlay Copyright
//
// Copyright (c) 2008-2009, Institute of Telematics, Universität Karlsruhe (TH)
//
// Institute of Telematics
// Universität Karlsruhe (TH)
// Zirkel 2, 76128 Karlsruhe
// Germany
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE INSTITUTE OF TELEMATICS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE ARIBA PROJECT OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// The views and conclusions contained in the software and documentation
// are those of the authors and should not be interpreted as representing
// official policies, either expressed or implied, of the Institute of
// Telematics.
// [License]

#ifndef __NETWORK_CHANGE_DETECTION_H
#define __NETWORK_CHANGE_DETECTION_H

// Forward declarations
struct nlmsghdr;

#include <vector>
#include <boost/thread/thread.hpp>

#include "NetworkInformation.h"
#include "NetworkChangeInterface.h"
#include "ariba/utility/logging/Logging.h"
#include "ariba/utility/system/SystemEventListener.h"

namespace ariba {
namespace communication {

using ariba::utility::SystemEvent;
using ariba::utility::SystemEventListener;

class NetworkChangeDetection : public SystemEventListener {
	use_logging_h(NetworkChangeDetection);
public:
	NetworkChangeDetection();
	virtual ~NetworkChangeDetection();

	void registerNotification( NetworkChangeInterface* callback );
	void unregisterNotification( NetworkChangeInterface* callback );

protected:
	void handleSystemEvent( const SystemEvent& event );

private:
	typedef std::vector<NetworkChangeInterface*> RegistrationList;
	RegistrationList registrations;

	void startMonitoring();
	void stopMonitoring();

	volatile bool running;
	boost::thread* monitoringThread;
	static void monitoringThreadFunc( NetworkChangeDetection* obj );

	int routingSocket;
	NetworkInformation networkInformation;

	NetworkChangeInterface::NetworkChangeInfo extractAddressEvent( struct nlmsghdr* header );
};

}} // namespace ariba, communication

#endif // __NETWORK_CHANGE_DETECTION_H
